<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Sunny-Side Gym Registration</title>
  <script src="https://cdn.jsdelivr.net/npm/signature_pad@4.1.6/dist/signature_pad.umd.min.js"></script>

  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    .waiver-text {
      max-height: 300px;
      overflow-y: auto;
      border: 1px solid #ddd;
      padding: 15px;
      background: #f9f9f9;
      margin-bottom: 20px;
    }
    canvas.signature-pad {
      border: 1px solid #ccc;
      width: 100%;
      height: 200px;
      cursor: crosshair;
    }
  </style>
</head>
<body>
<div class="container my-5">
  <h2 class="mb-4">Sunny-Side Gym Registration Form</h2>
  <form method="post" action="">
 
<h4 class="mt-4">Personal Details</h4>
    <!-- Personal Details -->
    <div class="mb-3">
      <label>Name:</label>
      <input type="text" name="name" class="form-control">
    </div>
    <div class="mb-3">
      <label>Contact Tel. No:</label>
      <input type="text" name="contact_tel" class="form-control">
    </div>
    <div class="mb-3">
  <label>Email Address:</label>
  <input type="email" name="email" class="form-control" required>
</div>
    <div class="mb-3">
      <label>Address:</label>
      <textarea name="address" class="form-control" rows="3"></textarea>
    </div>
   
    <div class="mb-3">
      <label>Do you identify as:</label><br>
      <input type="radio" name="gender" value="Male"> Male
      <input type="radio" name="gender" value="Female"> Female
    </div>
    <div class="mb-3">
      <label>Date of Birth:</label>
      <input type="date" name="dob" class="form-control">
    </div>
    <div class="mb-3">
      <label>Member No:</label>
      <input type="text" name="member_no" class="form-control">
    </div>
    <div class="mb-3">
      <label>Any medical condition:</label>
      <input type="text" name="medical_condition" class="form-control">
    </div>
    <div class="mb-3">
      <label>Current medication:</label>
      <textarea name="current_medication" class="form-control" rows="2"></textarea>
    </div>
    <div class="mb-3">
      <label>Next of Kin:</label>
      <input type="text" name="next_of_kin" class="form-control">
    </div>
    <div class="mb-3">
      <label>Relationship:</label>
      <input type="text" name="relationship" class="form-control">
    </div>
    <div class="mb-3">
      <label>Contact No. (Next of Kin):</label>
      <input type="text" name="kin_contact" class="form-control">
    </div>
    <div class="mb-3">
      <label>I give permission for Sunny-Side Gym to contact me with the details you provided?</label><br>
      <input type="radio" name="permission" value="Yes"> Yes
      <input type="radio" name="permission" value="No"> No
    </div>

    <h4 class="mt-4">Health History</h4>
    <!-- Health Questions -->
    <div class="mb-3"><label>Do you lose your balance because of dizziness, or do you ever lose consciousness?</label><br>
      <input type="radio" name="q1" value="Yes"> Yes <input type="radio" name="q1" value="No"> No</div>
    <div class="mb-3"><label>Has your doctor ever said you have a heart condition and should only do physical activity recommended by a doctor?</label><br>
      <input type="radio" name="q2" value="Yes"> Yes <input type="radio" name="q2" value="No"> No</div>
    <div class="mb-3"><label>Do you feel pain in your chest when you do physical activity?</label><br>
      <input type="radio" name="q3" value="Yes"> Yes <input type="radio" name="q3" value="No"> No</div>
    <div class="mb-3"><label>Are you being treated for high blood pressure?</label><br>
      <input type="radio" name="q4" value="Yes"> Yes <input type="radio" name="q4" value="No"> No</div>
    <div class="mb-3"><label>Do you have diabetes?</label><br>
      <input type="radio" name="q5" value="Yes"> Yes <input type="radio" name="q5" value="No"> No</div>
    <div class="mb-3"><label>Do you have asthma or any other respiratory problems?</label><br>
      <input type="radio" name="q6" value="Yes"> Yes <input type="radio" name="q6" value="No"> No</div>
    <div class="mb-3"><label>Do you have any bone or joint problems that could be made worse by change in your physical activity?</label><br>
      <input type="radio" name="q7" value="Yes"> Yes <input type="radio" name="q7" value="No"> No</div>
    <div class="mb-3"><label>Do you have epilepsy?</label><br>
      <input type="radio" name="q8" value="Yes"> Yes <input type="radio" name="q8" value="No"> No</div>
    <div class="mb-3"><label>Do you have a pacemaker?</label><br>
      <input type="radio" name="q9" value="Yes"> Yes <input type="radio" name="q9" value="No"> No</div>
    <div class="mb-3"><label>Are you pregnant?</label><br>
      <input type="radio" name="q10" value="Yes"> Yes <input type="radio" name="q10" value="No"> No</div>
    <div class="mb-3"><label>Do you know any other reasons you should not engage in physical activity?</label><br>
      <input type="radio" name="q11" value="Yes"> Yes <input type="radio" name="q11" value="No"> No</div>
    <div class="mb-3">
      <label>If you have answered yes to any of these questions, please add any other information here:</label>
      <textarea name="other_info" class="form-control" rows="3"></textarea>
    </div>

    <!-- FIRST WAIVER TEXT -->
    <h4 class="mt-4">Waiver & Assumption of Risk</h4>
    <div class="waiver-text">
      <p><strong>Waiver Issued by: Sunny-Side Gym Ltd, 7/9 Springfield Street Morecambe LA44HA</strong></p>
      <p>By submitting an order, (online or by other means), making an authorisation payment or by using any services supplied by Sunny-Side Gym Ltd trading as Sunny-Side Gym, the Customer agrees to Sunny-Side Gym Ltd Terms of Service (TOS) and Privacy Policy.</p>
      <p><strong>Express assumption of risk:</strong></p>
      <p>I, the undersigned, am aware that there are significant risks involved in any physical training regimen. These risks include but are not limited to: falls which can result in serious injury or death; injury or death due to negligence on the part of myself, my training partner, or other people around me, injury or death due to improper use or failure of equipment. Injury may also result simply from the fact of physical training itself.</p>
      <p>By its very nature, physical training seeks to have me push beyond my physical and mental limits in order to produce a physical adaptation by my body. Excessive work can result (in rare cases) in exertional rhabdomyolysis. I should look for signs of excessive soreness, darkened urine, and pain in the kidney areas in the days following a particularly intense workout. While this type of injury is rare, it can occur due to a number of factors, including (but not limited to) genetic predisposition, medication, or other factors that are beyond the control of my trainer. I am aware that any of these above mentioned risks may result in serious injury or death to myself and or my partner(s).</p>
      <p>I willingly assume full responsibility for the risks that I am exposing myself to and accept full responsibility for any injury or death that may result from participation in any activity or class while training at or with Sunny-Side Gym Ltd.</p>
    </div>

    <div class="mb-3">
      <label>Print Name:</label>
      <input type="text" name="waiver_print_name" class="form-control">
    </div>
    <div class="mb-3">
      <label>Signature:</label>
      <canvas id="signature-pad1" class="signature-pad"></canvas>
      <input type="hidden" name="signature_data1" id="signature_data1">
      <button type="button" class="btn btn-secondary btn-sm mt-2" id="clear-signature1">Clear Signature</button>
    </div>

    <!-- SECOND WAIVER TEXT -->
    <h4 class="mt-4">Release of Liability & Indemnification</h4>
    <div class="waiver-text">
      <p>I, the undersigned, acknowledge that I have no physical condition, illness, or impairment that I know of that will endanger myself or others.</p>
      <p><strong>Release of liability:</strong></p>
      <p>In consideration of the above mentioned risks and hazards and in consideration of the fact that I am willingly and voluntarily participating in the activities available at Sunny-Side Gym ltd, I, the undersigned hereby release Sunny-Side Gym Ltd, Inc., its officers and directors, and Sunny-Side Gym Ltd their principals, agents, employees, and volunteers from any and all liability, claims, demands, actions or rights of action, which are related to, arise out of, or are in any way connected with my participation in this activity, including those allegedly attributed to the negligent acts or omissions of the above mentioned parties.</p>
      <p>I affirm that I have stated all my known medical conditions and answered all questions honestly. I agree to keep Sunny-Side Gym ltd updated as to any changes in my medical profile and understand that there is no liability on Sunny-Side Gym Ltd part should I fail to do so.</p>
      <p>This agreement shall be binding upon me, my successors, representatives, heirs, executors, assigns, or transferees. If any portion of this agreement is held invalid, I agree that the remainder of the agreement shall remain in full legal force and effect.</p>
      <p><strong>Indemnification:</strong></p>
      <p>The participant recognizes that there is risk involved in the types of activities offered by Sunny-Side Gym Ltd. Therefore, the participant accepts financial responsibility for any injury that the participant may cause either to him/herself or to any other participant due to his/her negligence. Should the above-mentioned parties, or anyone acting on their behalf, be required to incur attorney’s fees and costs to enforce this agreement, I agree to reimburse them for such fees and costs. I further agree to indemnify and hold harmless Sunny-Side Gym Ltd, their principals, agents, employees, and volunteers from liability for the injury or death of any person(s) and damage to property that may result from my negligent or intentional act or omission while participating in activities offered by Sunny-Side Gym Ltd.</p>
    </div>

    <div class="mb-3">
      <label>Signed:</label>
      <canvas id="signature-pad2" class="signature-pad"></canvas>
      <input type="hidden" name="signature_data2" id="signature_data2">
      <button type="button" class="btn btn-secondary btn-sm mt-2" id="clear-signature2">Clear Signature</button>
    </div>
    <div class="mb-3">
      <label>Date:</label>
      <input type="date" name="signature_date" class="form-control">
    </div>

    <button type="submit" class="btn btn-primary mt-4">Submit Registration</button>
  </form>
</div>

<script>
  function resizeCanvas(canvas) {
    const ratio = Math.max(window.devicePixelRatio || 1, 1);
    canvas.width = canvas.offsetWidth * ratio;
    canvas.height = canvas.offsetHeight * ratio;
    canvas.getContext("2d").scale(ratio, ratio);
  }

  const canvas1 = document.getElementById('signature-pad1');
  const canvas2 = document.getElementById('signature-pad2');
  resizeCanvas(canvas1);
  resizeCanvas(canvas2);

  const sigPad1 = new SignaturePad(canvas1);
  const sigPad2 = new SignaturePad(canvas2);

  document.getElementById('clear-signature1').addEventListener('click', () => sigPad1.clear());
  document.getElementById('clear-signature2').addEventListener('click', () => sigPad2.clear());

  document.querySelector('form').addEventListener('submit', function() {
    if (!sigPad1.isEmpty()) {
      document.getElementById('signature_data1').value = sigPad1.toDataURL();
    }
    if (!sigPad2.isEmpty()) {
      document.getElementById('signature_data2').value = sigPad2.toDataURL();
    }
  });
</script>



<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
